
CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views  WHERE viewname = 'v_busca_preco') THEN 
		DROP VIEW IF EXISTS v_busca_preco;
        RAISE NOTICE 'v_busca_preco removida.';
    END IF; 
	

/*
--<<INICIO DO CORPO DA FUNCAO

=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221106
'Job.................:  
'Nome................:  v_busca_preco
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2022-11-06
'Alterado por........: Marcos barros
'Criado por..........: 
'======================================================================================= 
*/

CREATE OR REPLACE VIEW public.v_busca_preco
AS 
	SELECT 
		est_prod_cd_barra.cd_barra,
		est_prod.ds_prod,
        CASE
            WHEN est_prod_preco.vlr_oferta = 0::numeric THEN max(est_prod_preco.vlr_tabela)
            ELSE max(est_prod_preco.vlr_oferta)
        END AS preco
   FROM 
	est_prod_preco
    JOIN est_prod ON est_prod_preco.cd_emp = est_prod.cd_emp AND est_prod_preco.cd_prod = est_prod.cd_prod
    JOIN est_prod_cd_barra ON est_prod_preco.cd_emp = est_prod_cd_barra.cd_emp AND est_prod_preco.cd_prod = est_prod_cd_barra.cd_prod
  GROUP BY 
	est_prod_cd_barra.cd_barra, 
	est_prod.ds_prod, 
	est_prod_preco.vlr_oferta, 
	est_prod_preco.vlr_tabela;

-- Permissions

ALTER TABLE public.v_busca_preco OWNER TO postgres;
GRANT ALL ON TABLE public.v_busca_preco TO postgres;

	RAISE NOTICE 'View v_busca_preco recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();